 ; Ŀ
 ;   Cbom - combine "Bom.csv" and "Master Bom.csv" and suck into blocks.   
 ;   Copyright 2000, 2002, 2006, 2007, 2010 by Rocket Software Ltd.        
 ;                                                                         
 ; 

 ; Ŀ
 ;   Bulla - write a list of lists to a csv file.                          
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BULLA (lista filnam / fn sub str nxtstr)
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (setq str "")
         (while (setq nxtstr (car sub))
                (setq sub (cdr sub))
                (setq str (strcat str "," nxtstr)))
         (write-line (substr str 2) fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Bulla end.                                                            
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen oldlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len llen pos name1 strlst)
 ; Ŀ
 ;   First knock off leading spaces.  This prevents a string consisting    
 ;   only of spaces from getting into the main loop and crashing.          
 ; 
  (while (and (= (substr linn 1 1) " ")
              (/= (strlen linn) 0))
         (setq linn (substr linn 2)))
 ; Ŀ
 ;   Now process the string.  Note that the space remover is still         
 ;   required for leading spaces in individual fields.                     
 ; 
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")   ; character to split on
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= 0 (setq llen (strlen name1)))
                     (= (substr name1 llen) " "))
                (setq name1 (substr name1 1 (1- llen))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Fodcut - suck a cdf file into a list, deal correctly with             
 ;   encapsulated commas and inch symbols.                                 
 ;   Arguments: filnam, a filename.                                        
 ;   Calls Csplit and Nook.                                                
 ;   Returns a list of lists of strings.                                   
 ; 
 (DEFUN FODCUT (filnam / fn linn llist malist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (if (/= linn "")
                      (progn
 ; Ŀ
 ;   Remove extraneous commas and double quotes.                           
 ; 
                           (setq linn (nook linn))
 ; Ŀ
 ;   Convert to uppercase, divide into a list of strings.                  
 ; 
                           (setq llist (csplit (strcase linn)))
 ; Ŀ
 ;   Add the new sublist to malist.                                        
 ; 
                           (setq malist (append malist (list llist))))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Fodcut end.                                                           
 ; 

 ; Ŀ
 ;   Insbloc - insert a block.                                             
 ;   Takes three arguments: Blnam, the block name.                         
 ;                          Pa, the insertion point.                       
 ;                          Llist, the attribute value list.               
 ;   Returns nothing.                                                      
 ; 
 (DEFUN INSBLOC (blnam pa llist / nexstr)
 ; Ŀ
 ;   Try to load Misps.lsp, which contains the subroutines for scaling     
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Insert a data block, read the values from the string list Llist into  
 ;   the attributes.                                                       
 ; 
  (command ".insert" blnam pa (misps) "" "")
  (while (and (setq nexstr (car llist))
              (= 1 (getvar "cmdactive")))
         (setq llist (cdr llist))
         (if (= nexstr "") (setq nexstr " "))
         (command nexstr))
 ; Ŀ
 ;   Fill leftover attributes with empty strings.                          
 ; 
  (while (= 1 (getvar "cmdactive")) (command " ")))
 ; Ŀ
 ;   Insbloc end.                                                          
 ; 

 ; Ŀ
 ;   Nook - remove commas from strings which excel has encapsulated in     
 ;   double quotes so that Splat doesn't make one string into several.     
 ;   Takes one argument, the raw data string, returns it semi-processed.   
 ; 
 (DEFUN NOOK (linn / base pos nxchar inquot)
 ; Ŀ
 ;   Fields containing 38" are exported by Excel as "38""", so call Chug   
 ;   to change them to "38" which the cond section can handle.             
 ;   Later: """ is changed to |+", the cond section changes "38|+" to      
 ;   38|+ and the final insertion code changes this back to 38".           
 ;   Similarly commas in double quotes are changed to ^| and after Csplit  
 ;   has chopped the string up into fields the attribute inserter calls    
 ;   Chug to change ^| back into a comma.                                  
 ; 
  (setq linn (car (chug "\"\"\"" "|+\"" linn)))
  (setq base "")
  (setq pos 1)
  (while (/= "" (setq nxchar (substr linn pos 1)))
         (setq pos (1+ pos))
         (cond ((and (null inquot) (= nxchar "\""))
                (setq inquot t))
               ((and inquot (= nxchar "\""))
                (setq inquot ()))
               ((and inquot (= nxchar ","))
                (setq base (strcat base "^|")))
               (t
                (setq base (strcat base nxchar)))))
 base)
 ; Ŀ
 ;   Nook end.                                                             
 ; 

 ; Ŀ
 ;   Nooke - remove commas from strings which excel has encapsulated in    
 ;   double quotes so that Csplit doesn't make one string into several.    
 ;   Takes one argument, the raw data string.                              
 ;   Calls Chug.                                                           
 ;   Returns a more rational string.                                       
 ; 
 (DEFUN NOOKE (linn)
 ; Ŀ
 ;   Fields containing 38" are exported by Excel as "38""", so call Chug   
 ;   to change "" to |+, then " to nothing, then |+ back to ".             
 ; 
  (setq linn (car (chug "\"\"" "|+" linn)))
  (setq linn (car (chug "\"" "" linn)))
  (setq linn (car (chug  "|+" "\"" linn)))
 linn)
 ; Ŀ
 ;   Nooke end.                                                            
 ; 

 ; Ŀ
 ;   Quando - remove from a list any sublists with a second item which     
 ;   is an empty (or equivalent) string or which is a part of a header.    
 ;   Also the first item shouldn't be empty either.                        
 ;   Arguments: Malist, a list of lists, preferably of string.             
 ;   Returns a list of lists of strings.                                   
 ; 
 (DEFUN QUANDO (malist / num sub gnulis)
  (setq num 0)
  (while (setq sub (nth num malist))
         (setq num (1+ num))
         (if (and (cadr sub)
                  (not (member (car sub)
                              '("" " " "..." "  " "-" "_" "   " "ITEM NO.")))
                  (not (member (cadr sub)
                              '("" " " "..." "  " "-" "_" "   " "QUANTITY"))))
             (setq gnulis (append gnulis (list sub)))))
 gnulis)
 ; Ŀ
 ;   Quando end.                                                           
 ; 

 ; Ŀ
 ;   Reinch - Put back the commas and inch markers replaced by Nook.       
 ;   Arguments: Alist, a list of strings.                                  
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN REINCH (alist / num sub gnu)
  (setq num 0)
  (while (setq sub (nth num alist))
         (setq num (1+ num))
         (setq sub (car (chug "^|" "," sub)))
         (setq sub (car (chug "|+" "\"" sub)))
         (setq gnu (append gnu (list sub))))
 gnu)
 ; Ŀ
 ;   Reinch end.                                                           
 ; 

 ; Ŀ
 ;   Cbom.                                                                 
 ; 
 (DEFUN C:CBOM (/ blnam pref fnamp filnam malist filnbm addlst num sub chnum
                    cara asoc gnulis insp ss pa paorig len skip laynam cnum)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setvar "attreq" 1)
  (setvar "attdia" 0)
  (setvar "limcheck" 0)
  (setq blnam "bill of mat text")
 ; Ŀ
 ;   Get a base bom data file.                                             
 ; 
  (setq pref (getvar "dwgprefix"))
  (if (setq fnamp (findfile (strcat pref "master bom.csv")))
      (setq filnam fnamp)
      (progn
           (write-line "\n*Master Bom.csv Not Found.*")
           (exit)))
 ; Ŀ
 ;   Read the master bom data file into a list of lists of strings.        
 ; 
  (setq malist (fodcut filnam))
 ; Ŀ
 ;   Get a quantity file to add to it.                                     
 ; 
  (if (setq fnamp (findfile (strcat pref "bom.csv")))
      (setq filnbm fnamp)
      (progn
           (write-line "\n*Quantity File Bom.csv Not Found.*")
           (write-line "\n*You must run Bomex.lsp*")
           (exit)))
 ; Ŀ
 ;   Read the quantity file into a list of lists of strings.               
 ; 
  (setq addlst (fodcut filnbm))
 ; Ŀ
 ;   Do a quick check to see if any bom numbers have been extracted from   
 ;   the drawing which don't have matching lines in the mater data file.   
 ;   Print a warning if any are found.                                     
 ; 
  (setq num 0)
  (while (setq sub (nth num addlst))
         (setq num (1+ num))
         (if (not (assoc (setq chnum (car sub)) malist))
             (write-line (strcat "\n*** No Master Bom data found for "
                                 chnum ". ***"))))
 ; Ŀ
 ;   Add the quantities from the quantity file to the data from the file   
 ;   Master BOM.csv (saved from the matching excel file.)                  
 ;   The second item from the quantity file replaces the second item in    
 ;   the matching base file sublist.                                       
 ;   Lines which don't have a match in the quantity file are emptied and   
 ;   written to the output file, so Master Bom.csv can be reused without   
 ;   having to make a new copy from the excel file.                        
 ; 
  (setq num 0)
  (while (setq sub (nth num malist))
         (setq num (1+ num))
         (setq cara (car sub))
         (if (setq asoc (assoc cara addlst))
             (setq sub (cons cara (cons (cadr asoc) (cddr sub))))
             (if (/= cara "Item No.")
                 (setq sub (cons cara (cons "" (cddr sub))))))
         (setq gnulis (append gnulis (list sub))))
 ; Ŀ
 ;   Write the new list out to the base csv file name.                     
 ; 
  (bulla gnulis filnam)
 ; Ŀ
 ;   Erase all existing data block insertions, but ask first.              
 ; 
  (initget 0 "Yes No")
  (Setq insp (getkword "\nErase Existing BOM Blocks <Y>: "))
  (if (or (null insp) (= insp "Yes"))
      (progn
           (if (setq ss (ssget "X" (list (cons 2 blnam))))
               (command "erase" ss ""))))
 ; Ŀ
 ;   Read the rehashed Master Bom.csv into a list of lists of strings.     
 ; 
  (setq malist (fodcut filnam))
 ; Ŀ
 ;   Remove from Malist any sublists with empty second (quantity)          
 ;   attributes.                                                           
 ; 
  (setq malist (quando malist))
 ; Ŀ
 ;   Set the start point.  This depends on the use of the correct title    
 ;   block and it being positioned at as close to 0,0 as it can get.       
 ; 
  (if (null (setq pa (getpoint "Base Point <Auto>: ")))
      (setq pa '(26 529)))
  (setq paorig pa)
 ; Ŀ
 ;   See how long Malist is, decide if there is room for spacer lines.     
 ; 
  (setq len (length malist))
  (if (< len 145) (setq skip t))
 ; Ŀ
 ;   Make the text layer current, or make it.                              
 ; 
  (setq laynam "text")
  (if (tblsearch "layer" laynam)
      (setvar "clayer" laynam)
      (command "layer" "m" laynam "c" 2 "" ""))
 ; Ŀ
 ;   While there are lines in Malist, insert blocks.                       
 ; 
  (setq num 0)
  (setq cnum 0)
  (while (setq sub (nth num malist))
         (setq num (1+ num))
         (setq cnum (1+ cnum))
         (insbloc blnam pa sub)
 ; Ŀ
 ;   Deal with vertical positioning.                                       
 ; 
         (if (and skip (zerop (rem num 5)))
             (setq pa (polar pa (* pi 1.5) 12))
             (setq pa (polar pa (* pi 1.5) 6)))
 ; Ŀ
 ;   See if we need to go to the other side.                               
 ; 
         (if (and (< (car pa) 100)             ; admittedly kludgy
                  (or (and skip (> num 69))
                      (> num 86)))
             (progn
                  (setq pa (polar paorig 0 348))
                  (setq cnum 0))))
 ; Ŀ
 ;   End politely.                                                         
 ; 
  (command "undo" "end")
 (princ))